-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("victory")
  self:AddTriggerTarget("defeat")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.defeat = false
    self.timer = 4
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.victory = 0
      MarkMainGoal(self)
    end    
  end
  
  if self.defeat then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      self.p0:FailQuest('D1G_GOAL_1')
      self.p0:FailQuest('D1G_GOAL_2')
      Citadels.ForceDefeat()
    end
    
  end
  
  if self.victory == 2 then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      self.p0:WinQuest('D1G_GOAL_2')
      Citadels.SetAchievementDone(8)
      Citadels.ForceVictory()
    end
  end

end

function MarkMainGoal(self)
  gPosX = Game:GetEntity("castlePos"):GetPosition().x
  gPosY = Game:GetEntity("castlePos"):GetPosition().y

  self.p0:AddQuest('D1G_GOAL_1','main')
  self.p0:SetQuestPosition('D1G_GOAL_1', gPosX, gPosY)
end

function OnTrigger(self, source, target)
  if target == "victory" then
    self.victory = self.victory + 1
  elseif target == "defeat" then
    self.defeat = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.victory = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.victory)
  end
end
